package rahmawati.paerah.jaluralternatif;

import android.Manifest;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.Typeface;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMap.OnMarkerClickListener;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

public class Activity_Map extends FragmentActivity implements
		LocationListener, OnMarkerClickListener, OnMapReadyCallback {

	final int RQS_GooglePlayServices = 1;
	GoogleMap gMap;
	LatLng gorsouth =new LatLng(0.5473091, 123.0361635);
	double latitude, longitude;
	ProgressDialog pDialog;

	ArrayList<HashMap<String, String>> dataList = new ArrayList<HashMap<String, String>>();


	JSONArray college = null;


	ConnectionDetector cd;
	Boolean isInternetPresent = false;

	AlertDialogManager alert = new AlertDialogManager();

	HashMap<String, String> map;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_mapjalur);

		cekInternet();

		SupportMapFragment mapFragment =
				(SupportMapFragment) getSupportFragmentManager().findFragmentById(R.id.map);
		mapFragment.getMapAsync(this);



try {
	CekGPS();
}catch (Exception e){

}




	//	refresh = (Button) findViewById(R.id.reload);
	//	refresh.setOnClickListener(new View.OnClickListener() {

			//@Override
			//public void onClick(View arg0){
			//			// TODO Auto-generated method stub
			///		cekInternet();


			//	cari = (Button) findViewById(R.id.cari);
			//	cari.setOnClickListener(new View.OnClickListener() {

			//		@Override
			//		public void onClick(View arg0) {
			//			// TODO Auto-generated method stub
			//			Intent i = new Intent(getApplicationContext(), Activity_TampilanMap.class);
			//			startActivity(i);
			//		}
		}

	/*@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.cari, menu);
		return true;

	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
			case R.id.action_cari:
				Intent imap= new Intent(this, Activity_hitung.class);
				startActivity(imap);
				return true;

			default:
				return super.onOptionsItemSelected(item);
		}

	}*/


	public void onBackPressed() {
		Intent imap= new Intent(this, menu_utama.class);
		startActivity(imap);
		finish();
	}

	@Override
	public void onMapReady(GoogleMap googleMap) {
		gMap = googleMap;
		gMap.setMapType(GoogleMap.MAP_TYPE_NORMAL);
		gMap.moveCamera(CameraUpdateFactory.newLatLng(gorsouth));
		if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
			// TODO: Consider calling
			//    ActivityCompat#requestPermissions
			// here to request the missing permissions, and then overriding
			//   public void onRequestPermissionsResult(int requestCode, String[] permissions,
			//                                          int[] grantResults)
			// to handle the case where the user grants the permission. See the documentation
			// for ActivityCompat#requestPermissions for more details.
			return;
		}
		gMap.setInfoWindowAdapter(new GoogleMap.InfoWindowAdapter() {
			@Override
			public View getInfoWindow(Marker marker) {


				return null;
			}

			@Override
			public View getInfoContents(Marker marker) {
				LinearLayout info = new LinearLayout(getApplicationContext());
				info.setOrientation(LinearLayout.VERTICAL);

				TextView title = new TextView(getApplicationContext());
				title.setTextColor(Color.BLACK);
				title.setGravity(Gravity.CENTER);
				title.setTypeface(null, Typeface.BOLD);
				title.setText(marker.getTitle());

				TextView snippet = new TextView(getApplicationContext());
				snippet.setTextColor(Color.GRAY);
				snippet.setText(marker.getSnippet());

				info.addView(title);
				info.addView(snippet);

				return info;

			}
		});
		gMap.setMyLocationEnabled(true);
		gMap.setTrafficEnabled(true);
		gMap.setIndoorEnabled(true);
		gMap.setBuildingsEnabled(true);
		gMap.getUiSettings().setZoomControlsEnabled(true);
	}

	public class AmbilData extends AsyncTask<String, String, String> {

		@Override
		protected void onPreExecute() {
			super.onPreExecute();
			pDialog = new ProgressDialog(Activity_Map.this);
			pDialog.setMessage("Tunggu Sebentar ...");
			pDialog.setIndeterminate(false);
			pDialog.setCancelable(true);
			pDialog.show();
		}

		@Override
		protected String doInBackground(String... arg0) {
			String url;
CONFIG_URL cu = new CONFIG_URL();
			url = cu.getUrljalur();

			JSONParser jParser = new JSONParser();

			JSONObject json = jParser.getJSONFromUrl(url);
			try {
				college = json.getJSONArray("jalur");
				Log.e("error", json.getString("success"));

				for (int i = 0; i <= college.length(); i++) {

					JSONObject c = college.getJSONObject(i);

					map = new HashMap<String, String>();

					String id_1 = c.getString("id").trim();
					String latitude_1 = c.getString("lati").trim();
					String longitude_1 = c.getString("longi").trim();
					String nama_1 = c.getString("nama").trim();
					String jammacet = c.getString("jammacet").trim();



					map.put("id", id_1);
					map.put("nama", nama_1);
					map.put("jam", jammacet);
					map.put("lati", latitude_1);
					map.put("longi", longitude_1);






					dataList.add(map);

				}

			} catch (JSONException e) {

			}

			return null;
		}

		@Override
		protected void onPostExecute(String result) {
			// TODO Auto-generated method stub
			super.onPostExecute(result);
			pDialog.dismiss();
			try {
			for (int x = 0; x < dataList.size(); x = x + 1) {

				double latasal = Double.parseDouble(dataList.get(x).get(
						"lati"));
				double longasal = Double.parseDouble(dataList.get(x).get(
						"longi"));
				LatLng posisi = new LatLng(latasal, longasal);
				String nama = dataList.get(x).get("nama");
				String al = dataList.get(x).get("alamat");
				String jamm = dataList.get(x).get("jam");


				Log.e("is", "latlang " + posisi );

				gMap.addMarker(new MarkerOptions()
						.position(posisi)
						.title(nama)
						.snippet(jamm )
						.icon(BitmapDescriptorFactory.fromResource(R.drawable.jaluricon)));
				// .icon(BitmapDescriptorFactory.defaultMarker(BitmapDescriptorFactory.HUE_AZURE)));

				}
			}catch (Exception e) {

	Log.e("is", "gagal addmarker " + e );
}


			}

		}




	@Override
	public void onLocationChanged(Location location) {
		// TODO Auto-generated method stub
		try {
			latitude = location.getLatitude();
			longitude = location.getLongitude();
		} catch (Exception e) {
			// TODO: handle exception
		}
	}

	public void CekGPS() {
		try {
			LocationManager manager = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
			if (!manager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
				AlertDialog.Builder builder = new AlertDialog.Builder(this);
				builder.setTitle("info");
				builder.setMessage("Apakah anda akan mengaktifkan GPS?");
				builder.setPositiveButton("Ya",
						new DialogInterface.OnClickListener() {

							@Override
							public void onClick(DialogInterface arg0, int arg1) {
								// TODO Auto-generated method stub
								Intent i = new Intent(
										android.provider.Settings.ACTION_LOCATION_SOURCE_SETTINGS);
								startActivity(i);

							}
						});
				builder.setNegativeButton("Tidak",
						new DialogInterface.OnClickListener() {

							@Override
							public void onClick(DialogInterface dialog, int arg1) {
								// TODO Auto-generated method stub
								dialog.dismiss();
							}
						});
				builder.create().show();
			}
		} catch (Exception e) {
			// TODO: handle exception

		}
		int status = GooglePlayServicesUtil
				.isGooglePlayServicesAvailable(getBaseContext());
		if (status != ConnectionResult.SUCCESS) {
			int requestCode = 10;
			Dialog dialog = GooglePlayServicesUtil.getErrorDialog(status, this,
					requestCode);
			dialog.show();
		} else {

			Criteria criteria = new Criteria();
			LocationManager locationmanager = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
			String provider = locationmanager.getBestProvider(criteria, true);
			if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
				// TODO: Consider calling
				//    ActivityCompat#requestPermissions
				// here to request the missing permissions, and then overriding
				//   public void onRequestPermissionsResult(int requestCode, String[] permissions,
				//                                          int[] grantResults)
				// to handle the case where the user grants the permission. See the documentation
				// for ActivityCompat#requestPermissions for more details.
				return;
			}
			Location location = locationmanager.getLastKnownLocation(provider);
			
			if (location != null) {
				onLocationChanged(location);
			}
			
			locationmanager.requestLocationUpdates(provider, 500, 0, this);
			LatLng posisi = new LatLng(latitude, longitude);
		try{
			gMap.animateCamera(CameraUpdateFactory.newLatLngZoom(posisi,
					12));}
		catch (Exception e){
	Log.e( "haris","CekGPS: " + e );
		}
			gMap.setOnMarkerClickListener(this);
		}
	}

	@Override
	public void onProviderDisabled(String provider) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onProviderEnabled(String provider) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onStatusChanged(String provider, int status, Bundle extras) {
		// TODO Auto-generated method stub

	}

	public void cekInternet() {
		cd = new ConnectionDetector(getApplicationContext());
		isInternetPresent = cd.isConnectingToInternet();

		if (isInternetPresent) {

			new AmbilData().execute();

		} else {

			alert.showAlertDialog(Activity_Map.this, "Peringatan",
					"cek koneksi internet.", false);
		}
	}

	@Override
	public boolean onMarkerClick(Marker marker) {
		// TODO Auto-generated method stub
		
		/*String id= marker.getId();
		id = id.substring(1);
		
		Intent x = new Intent(getApplicationContext(), Detail.class);
		x.putExtra("nama", dataList.get(Integer.parseInt(id)).get("nama"));
		x.putExtra("gambar", dataList.get(Integer.parseInt(id)).get("gambar"));
		x.putExtra("alamat", dataList.get(Integer.parseInt(id)).get("alamat"));
		
		startActivity(x);*/

		return false;
	}

}
